<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\Data\Dtos\Notification\NotificationLinkedContentDTO;

trait TraitNotificationGetters
{
    use TraitNotificationProperties;

    public function getId(): string
    {
        return $this -> id;
    }

    public function getToUserId(): string
    {
        return $this -> toUserId;
    }

    public function getTargetContentId(): string
    {
        return $this -> targetContentId;
    }

    public function getLinkedContent(): NotificationLinkedContentDTO
    {
        return $this -> linkedContent;
    }

    public function getMetaType(): string
    {
        return $this -> metaType;
    }

    public function getMetaIsRead(): string
    {
        return $this -> metaIsRead;
    }

    public function getMetaIsTransient(): string
    {
        return $this -> metaIsTransient;
    }

    public function getStampRegistrationDate(): string
    {
        return $this -> stampRegistrationDate;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
